/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.wizard.modem;

import DE.siemens.ad.logo.dialog.wizard.WizardInputPanel;
import DE.siemens.ad.logo.dialog.wizard.WizardPanelModel;
import DE.siemens.ad.logo.dialog.wizard.modem.SetRemoteModemCommandModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoModemSetting;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetRemoteModemCommandPanel
extends WizardInputPanel {
    private SetRemoteModemCommandModel model;
    private JPanel modemSettingPanel;
    private JLabel resetLabel;
    private JLabel disableEchoLabel;
    private JLabel dialToneLabel;
    private JLabel dataFlowLabel;
    private JLabel ignoreDTRLabel;
    private JLabel enableSYncModeLabel;
    private JLabel takeCallLabel;
    private JLabel saveConfigLabel;
    private JLabel additionalLabel;
    private JTextField resetText;
    private JTextField disableEchoText;
    private JTextField dialToneText;
    private JTextField dataFlowText;
    private JTextField ignoreDTRText;
    private JTextField enableSYncModeText;
    private JTextField takeCallText;
    private JTextField saveConfigText;
    private JTextField additionalText;
    private JCheckBox useDefault;
    private boolean local;
    private Hashtable atCommand;
    private JTextField modemNameField;
    private JButton saveConfig;
    private JPanel savePanel;

    public Icon getIcon() {
        return null;
    }

    public SetRemoteModemCommandPanel(String modemName, WizardPanelModel panelModel) {
        super(panelModel);
        this.model = (SetRemoteModemCommandModel)panelModel;
        this.initialize(modemName);
    }

    private void initialize(String modemName) {
        this.setLayout(new FlowLayout(1));
        this.add(this.getCommandSettingPanel(modemName));
    }

    private JPanel getCommandSettingPanel(String modemName) {
        if (this.modemSettingPanel == null) {
            this.modemSettingPanel = new JPanel();
            this.modemSettingPanel.setLayout(new GridBagLayout());
            this.modemNameField = new JTextField(10);
            this.modemNameField.setText(modemName);
            this.resetLabel = new JLabel();
            this.resetText = new JTextField();
            this.disableEchoLabel = new JLabel();
            this.disableEchoText = new JTextField();
            this.dialToneLabel = new JLabel();
            this.dialToneText = new JTextField();
            this.dataFlowLabel = new JLabel();
            this.dataFlowText = new JTextField();
            this.ignoreDTRLabel = new JLabel();
            this.ignoreDTRText = new JTextField();
            this.enableSYncModeLabel = new JLabel();
            this.enableSYncModeText = new JTextField();
            this.takeCallLabel = new JLabel();
            this.takeCallText = new JTextField();
            this.saveConfigLabel = new JLabel();
            this.saveConfigText = new JTextField();
            this.additionalLabel = new JLabel();
            this.additionalText = new JTextField();
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 4, 2, 4);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.modemSettingPanel.add((Component)new JLabel(Language.getString("wizard.modem.setRemoteModemCommandPanel.modemName", "Modem name")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.modemSettingPanel.add((Component)this.modemNameField, constraints);
            constraints.insets = new Insets(0, 4, 4, 4);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.modemSettingPanel.add((Component)this.resetLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            this.modemSettingPanel.add((Component)this.resetText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 3;
            this.modemSettingPanel.add((Component)this.disableEchoLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 3;
            this.modemSettingPanel.add((Component)this.disableEchoText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 4;
            this.modemSettingPanel.add((Component)this.dialToneLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 4;
            this.modemSettingPanel.add((Component)this.dialToneText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 5;
            this.modemSettingPanel.add((Component)this.dataFlowLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 5;
            this.modemSettingPanel.add((Component)this.dataFlowText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 6;
            this.modemSettingPanel.add((Component)this.ignoreDTRLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 6;
            this.modemSettingPanel.add((Component)this.ignoreDTRText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 7;
            this.modemSettingPanel.add((Component)this.enableSYncModeLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 7;
            this.modemSettingPanel.add((Component)this.enableSYncModeText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 8;
            this.modemSettingPanel.add((Component)this.takeCallLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 8;
            this.modemSettingPanel.add((Component)this.takeCallText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 9;
            this.modemSettingPanel.add((Component)this.additionalLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 9;
            this.modemSettingPanel.add((Component)this.additionalText, constraints);
            constraints.gridx = 0;
            constraints.gridy = 10;
            this.modemSettingPanel.add((Component)this.saveConfigLabel, constraints);
            constraints.insets = new Insets(0, 4, 2, 4);
            constraints.gridx = 1;
            constraints.gridy = 10;
            this.modemSettingPanel.add((Component)this.saveConfigText, constraints);
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.gridx = 0;
            constraints.gridy = 11;
            constraints.gridwidth = 2;
            constraints.anchor = 13;
            this.modemSettingPanel.add((Component)this.getSavePanel(), constraints);
            constraints.insets = new Insets(0, 4, 2, 4);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.anchor = 17;
            this.modemSettingPanel.add((Component)this.getCheckBox(), constraints);
            if (this.modemNameField.getText().equals("")) {
                this.modemNameField.setEditable(true);
                this.useDefault.setSelected(true);
                this.setDefaultSetting();
            } else {
                this.modemNameField.setEditable(false);
                this.useDefault.setSelected(false);
                this.setDefinedSetting();
            }
        }
        return this.modemSettingPanel;
    }

    private JPanel getSavePanel() {
        if (this.savePanel == null) {
            this.savePanel = new JPanel(new FlowLayout(2));
            this.saveConfig = new JButton(Language.getString("wizard.modem.setLocalModemCommandPanel.saveConfig", "Save Configuration"));
            this.saveConfig.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SetRemoteModemCommandPanel.this.checkModemName()) {
                        if (SetRemoteModemCommandPanel.this.saveConfiguration()) {
                            SetRemoteModemCommandPanel.this.modemNameField.setEditable(false);
                            new LogoError(null, "wizard.modem.saveConfiguration.success", "Save successfully.", 1).display();
                        } else {
                            new LogoError(null, "wizard.modem.saveConfiguration.failed", "Save failed", 0).display();
                        }
                    }
                }
            });
            this.savePanel.add(this.saveConfig);
        }
        return this.savePanel;
    }

    private JCheckBox getCheckBox() {
        if (this.useDefault == null) {
            this.useDefault = new JCheckBox(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
            this.useDefault.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (SetRemoteModemCommandPanel.this.useDefault.isSelected()) {
                        SetRemoteModemCommandPanel.this.setDefaultSetting();
                    } else {
                        SetRemoteModemCommandPanel.this.setDefinedSetting();
                    }
                }
            });
        }
        return this.useDefault;
    }

    public void setLabels() {
        this.title = Language.getString("wizard.modem.setRemoteModemCommandPanel.configCommand", "Configure remote modem command");
        this.resetLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.reset", "Reset modem factory setting"));
        this.disableEchoLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.disableEcho", "Disable echo"));
        this.dialToneLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.dialTone", "Dial without dial tone detection"));
        this.dataFlowLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.dataFlow", "Disable data flow control"));
        this.ignoreDTRLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.ignoreDTR", "Ignore DTR"));
        this.enableSYncModeLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.enableSYncMode", "Enable synchronous mode"));
        this.takeCallLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.takeCall", "Take the call after the first ring"));
        this.additionalLabel.setText(Language.getString("wizard.modem.setRemoteModemCommandPanel.additional", "Additional (separated by blank)"));
        this.saveConfigLabel.setText(Language.getString("wizard.modem.setLocalModemCommandPanel.saveConfig", "Save configuration"));
        this.useDefault.setText(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
    }

    private void setDefaultSetting() {
        this.setSettingEditable(false);
        this.resetText.setText("&F");
        this.disableEchoText.setText("E0");
        this.dialToneText.setText("X3");
        this.dataFlowText.setText("&K0");
        this.ignoreDTRText.setText("&D0");
        this.enableSYncModeText.setText("\\N0");
        this.takeCallText.setText("S0=1");
        this.additionalText.setText("");
        this.saveConfigText.setText("&W");
    }

    private void setDefinedSetting() {
        this.setSettingEditable(true);
        LogoModemSetting modemSetting = LogoModemSetting.getInstance();
        this.atCommand = modemSetting.getAtSetting(this.local, this.modemNameField.getText());
        if (this.atCommand.get("reset") != null) {
            this.resetText.setText(this.atCommand.get("reset").toString());
        }
        if (this.atCommand.get("disableEcho") != null) {
            this.disableEchoText.setText(this.atCommand.get("disableEcho").toString());
        }
        if (this.atCommand.get("dialTone") != null) {
            this.dialToneText.setText(this.atCommand.get("dialTone").toString());
        }
        if (this.atCommand.get("dataFlow") != null) {
            this.dataFlowText.setText(this.atCommand.get("dataFlow").toString());
        }
        if (this.atCommand.get("ignoreDTR") != null) {
            this.ignoreDTRText.setText(this.atCommand.get("ignoreDTR").toString());
        }
        if (this.atCommand.get("enableSYncMode") != null) {
            this.enableSYncModeText.setText(this.atCommand.get("enableSYncMode").toString());
        }
        if (this.atCommand.get("takeCall") != null) {
            this.takeCallText.setText(this.atCommand.get("takeCall").toString());
        }
        if (this.atCommand.get("saveConfig") != null) {
            this.saveConfigText.setText(this.atCommand.get("saveConfig").toString());
        }
        if (this.atCommand.get("additional") != null) {
            this.additionalText.setText(this.atCommand.get("additional").toString());
        }
    }

    private void setSettingEditable(boolean editable) {
        this.resetText.setEditable(editable);
        this.disableEchoText.setEditable(editable);
        this.dialToneText.setEditable(editable);
        this.dataFlowText.setEditable(editable);
        this.ignoreDTRText.setEditable(editable);
        this.enableSYncModeText.setEditable(editable);
        this.takeCallText.setEditable(editable);
        this.saveConfigText.setEditable(editable);
        this.additionalText.setEditable(editable);
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        this.atCommand = new Hashtable();
        this.atCommand.put("reset", this.resetText.getText());
        this.atCommand.put("disableEcho", this.disableEchoText.getText());
        this.atCommand.put("dialTone", this.dialToneText.getText());
        this.atCommand.put("dataFlow", this.dataFlowText.getText());
        this.atCommand.put("ignoreDTR", this.ignoreDTRText.getText());
        this.atCommand.put("enableSYncMode", this.enableSYncModeText.getText());
        this.atCommand.put("takeCall", this.takeCallText.getText());
        this.atCommand.put("additional", this.additionalText.getText());
        this.atCommand.put("saveConfig", this.saveConfigText.getText());
        this.model.setAtCommand(this.atCommand);
    }

    private boolean checkModemName() {
        if (this.modemNameField.isEditable() && this.modemNameField.getText().equals("")) {
            new LogoError(this, "wizard.modem.setRemoteModemCommandPanel.noModemNameError", "You must enter a modem name", 0).display();
            return false;
        }
        if (this.modemNameField.isEditable() && !LogoModemSetting.getInstance().checkModemName(false, this.modemNameField.getText())) {
            new LogoError(this, "wizard.modem.setRemoteModemCommandPanel.modemNameExist", "The modem name has already existed.", 0).display();
            return false;
        }
        return true;
    }

    public String getHelpIdString() {
        return "extras.setRemoteModemCommand";
    }

    private boolean saveConfiguration() {
        boolean sucess = false;
        this.atCommand = new Hashtable();
        this.atCommand.put("reset", this.resetText.getText());
        this.atCommand.put("disableEcho", this.disableEchoText.getText());
        this.atCommand.put("dialTone", this.dialToneText.getText());
        this.atCommand.put("enableSYncMode", this.enableSYncModeText.getText());
        this.atCommand.put("additional", this.additionalText.getText());
        this.atCommand.put("takeCall", this.takeCallText.getText());
        this.atCommand.put("dataFlow", this.dataFlowText.getText());
        this.atCommand.put("saveConfig", this.saveConfigText.getText());
        this.atCommand.put("ignoreDTR", this.ignoreDTRText.getText());
        LogoModemSetting modemSetting = LogoModemSetting.getInstance();
        sucess = this.modemNameField.isEditable() ? modemSetting.addNewModem(false, this.modemNameField.getText(), this.atCommand) : modemSetting.modifyModemSetting(false, this.modemNameField.getText(), this.atCommand);
        return sucess;
    }
}

